!  Helmholtz_koker.f90 
!
!  FUNCTIONS:
!  Helmholtz_koker - Entry point of console application.
!

!****************************************************************************
!
!  PROGRAM: Helmholtz_koker
!
!  PURPOSE:  Entry point for the console application.
!
!****************************************************************************
module Mod
    double precision, PARAMETER :: kb_constant = 0.13806488D-22
    double precision, parameter :: h_bar= 1.054571726D-34
    double precision, parameter :: N_Av=6.02214129D+23
    
    double precision, parameter ::  Pi = 3.141592653589793D+0

end module Mod
    
subroutine ReadDeKokerFile(FileName,aepfit300,nepfit300,Vref300,fsn301,Tref300,thn301,ntot,nspeci,atmass,elbeto, elbetpow, elTeo, elTepow, elVo)
      character*200 FileName, LComment
      integer open_status,inpfid,aperf,nspec,i
      integer figfm, fclfm, felfm
      integer nspeci(3),zspeci(3)
      double precision atmass(3),Vref200(1), Tref200(1), Eref200(1), Sref200(1), Vref300(1), Tref300(1), Eref300(1), Sref300(1)
      double precision aepfit300(1,36),ntot
      !******************************************
      integer vffm300(1),tffm300(1),nepfit300(1)
      double precision fsn301(1),thn301(1)
      double precision figtfm, figrfm, figefm
      !******************************************
      
      
      
      double precision formmass
      double precision elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1)
      inpfid=4
      open (inpfid, file=FileName, iostat=open_status,status='old',action='read')
    
      read(inpfid,*) 
      read(inpfid,*) ntot
      !read(inpfid,*) aperf
      read(inpfid,*) formmass ! atomic mass of the liquid considered
      read(inpfid,*) nspec ! nb of species in the liquid structure considered
      read(inpfid,*) (nspeci(i), i=1,nspec)  ! stoichiometry of each species
      read(inpfid,*) (zspeci(i), i=1,nspec) ! atomic number of each species
      read(inpfid,*) (atmass(i), i=1,nspec) ! atomic mass of each species
      read(inpfid,*) figfm, fclfm, felfm  ! option integer 

      if (fclfm.eq.220) then
      read(inpfid,*)
      read(inpfid,*) Vref200(1), Tref200(1), Eref200(1), Sref200(1)
      !read(inpfid,*) fsn201(1)
      !read(inpfid,*) npfit200(1), (pfit200(1,i),i=1,npfit200(1))
      !read(inpfid,*) (akfit200(1,i),i=1,2)
      !read(inpfid,*) cvfit200(1,1)

      elseif (fclfm.eq.340) then

      read(inpfid,*)
      read(inpfid,*) Vref300(1), Tref300(1), Eref300(1), Sref300(1)   
      read(inpfid,*) vffm300(1) !??
      read(inpfid,*) fsn301(1) ! n parameter for theta ?
      read(inpfid,*) tffm300(1) !??
      read(inpfid,*) thn301(1)! m value for fxs
      read(inpfid,*) nepfit300(1), (aepfit300(1,i),i=1,nepfit300(1))

      endif

      if (felfm.eq.200) then
        read(inpfid,*)
        read(inpfid,*) elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1)
      endif

      if (figfm.eq.1) then
        read(inpfid,*)
        read(inpfid,*) figtfm, figrfm, figefm
        if (figefm.ne.0) then
          do i=1,nspec
           ! read(inpfid,*) naes(i)
           ! read(inpfid,*) (jel(i,j),j=1,naes(i))
           ! read(inpfid,*) (eel(i,j),j=1,naes(i))
          enddo
        endif
      endif

    end

   
    subroutine ConvertParameters (aij_matrix,aepfit300)
    double precision aij_matrix(6,3),aepfit300(1,36)
      aij_matrix=0. 
      aij_matrix(1,1)=aepfit300(1,1)  ! 0 0
      
      aij_matrix(2,1)=aepfit300(1,2)   ! 1 0  volume functional (finite strain)
      aij_matrix(1,2)=aepfit300(1,3)  ! 0 1  temperature functional

      aij_matrix(3,1)=aepfit300(1,4)   ! 2 0
      aij_matrix(2,2)=aepfit300(1,5)       ! 1 1
      aij_matrix(1,3)=aepfit300(1,6)  ! 0 2

      aij_matrix(4,1)=aepfit300(1,7)           ! 3 0
      aij_matrix(3,2)=aepfit300(1,8)   ! 2 1
      aij_matrix(2,3)=aepfit300(1,9)   ! 1 2
     ! aij_matrix(1,4)=aepfit300(1,10)          ! 0 3

      aij_matrix(5,1)=aepfit300(1,11)               ! 4 0
      aij_matrix(4,2)=aepfit300(1,12)       ! 3 1
      aij_matrix(3,3)=aepfit300(1,13)   ! 2 2
      !aij_matrix(2,4)=aepfit300(1,14)       ! 1 3
      !aij_matrix(1,5)=aepfit300(1,15)              ! 0 4

      aij_matrix(6,1)=aepfit300(1,16)                ! 5 0
      aij_matrix(5,2)=aepfit300(1,17)        ! 4 1
      aij_matrix(4,3)=aepfit300(1,18)    ! 3 2
     ! aij_matrix(3,4)=aepfit300(1,19)    ! 2 3
    !  aij_matrix(2,5)=aepfit300(1,20)        ! 1 4
    !  aij_matrix(1,6)=aepfit300(1,21)              ! 0 5

     ! aij_matrix(7,1)=aepfit300(1,22)                ! 6 0
      aij_matrix(6,2)=aepfit300(1,23)        ! 5 1
      aij_matrix(5,3)=aepfit300(1,24)    ! 4 2
      
     
       aij_matrix(6,3)=aepfit300(1,31)    ! 5 2
      
    
    end subroutine
    subroutine Calculate_PXS_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,PXS,T,V,factorialArray)
      double precision Vref300(1),aij_matrix(6,3),fsn301(1),Tref300(1),thn301(1),PXS,T,V,df_dV,factorialArray(6)  

      integer i,j
      double precision V0,T0,m,n,fstr,theta

      V0=Vref300(1)
      n=fsn301(1)
      T0= Tref300(1)
      m=thn301(1)
      
      
     

      ! Define the two adimentional functions for T et V
      fstr = 1.0D+0/n*((V0/V)**(n/3.0D+0)-1.0D+0)
      theta = ((T/T0)**m-1.0D+0)
      
      df_dV= -(1.0D+0/3.0D+0)*(V0/V)**((1.0D+0/3.0D+0)*n)/(V*1.0D-6)  
     
      PXS=0.0D+0
     

      do i=0,5
        do j=0,2
          PXS=PXS-aij_matrix(i+1,j+1)*fstr**(dble(i)-1.0D+0)*dble(i)*theta**(dble(j))/(factorialArray(i+1)*factorialArray(j+1))           
        enddo  
      enddo
      
      
      PXS=PXS*df_dV*1.0d-9*1.0d+3  
     
    end subroutine
    subroutine Calculate_SXS_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,SXS,T,V,factorialArray)

    double precision Vref300(1),aij_matrix(6,3),fsn301(1),Tref300(1),thn301(1),SXS,T,V,dTheta_dT,factorialArray(6)  

      integer i,j
      double precision V0,T0,m,n,fstr,theta

      V0=Vref300(1)
      n=fsn301(1)
      T0= Tref300(1)
      m=thn301(1)
      
      
     

      ! Define the two adimentional functions for T et V
      fstr = 1.0D+0/n*((V0/V)**(n/3.0D+0)-1.0D+0)
      theta = ((T/T0)**m-1.0D+0)
      
      dTheta_dT=(T/T0)**m*m/T
      
      SXS=0.0D+0
     

      do i=0,5
        do j=0,2
          SXS=SXS-aij_matrix(i+1, j+1)*fstr**i*theta**(dble(j)-1.0D+0)*dble(j)*dTheta_dT/(factorialArray(i+1)*factorialArray(j+1))    
        enddo  
      enddo
      
      
      SXS=SXS*1.0D+3
    
    endsubroutine
    
    subroutine  Calculate_Sideal(ntot,V,T,S_ideal,nspeci,atmass) 
   use Mod
   double precision ntot,V,T,S_ideal,atmass(3),q(3)
   integer nspeci(3)
     S_ideal=0.0D+0
     
     do i=1,3
       if (nspeci(i)>0.0D+0) then
         q(i)=(atmass(i)/N_Av*1D-3*kb_constant *T/(2*Pi*h_bar**2.0D+0))**(3.0D+0/2.0D+0)
         S_ideal=S_ideal+nspeci(i)*dlog((1.0D+0/4.0D+0)*dexp(1.0D+0)*V*1.0D-6*dsqrt(2.0D+0)*(atmass(i)/N_Av*1.0D-3*kb_constant*T/(Pi*h_bar**(2.0D+0)))**(3.0D+0/2.0D+0)/(nspeci(i)*N_Av))+(3.0D+0/2.0D+0)*nspeci(i)
       endif
     enddo
     
     S_ideal=kb_constant*N_Av*S_ideal
    
    end subroutine
    
    
    subroutine Calculate_HelmXS_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,HelmXS,T,V,factorialArray)
     double precision Vref300(1),aij_matrix(6,3),fsn301(1),Tref300(1),thn301(1),HelmXS,T,V,factorialArray(6)  

      integer i,j,lcount
      double precision V0,T0,m,n,fstr,theta
      double precision Contr(36)
      V0=Vref300(1)
      n=fsn301(1)
      T0= Tref300(1)
      m=thn301(1)
      
      
     

      ! Define the two adimentional functions for T et V
      fstr = 1.0D+0/n*((V0/V)**(n/3.0D+0)-1.0D+0)
      theta = ((T/T0)**m-1.0D+0)
    
     
      HelmXS=0.0D+0
     
      lcount=1
      do i=0,5
        do j=0,2
          
          HelmXS=HelmXS+aij_matrix(i+1,j+1)*fstr**i*theta**j/(factorialArray(1+i)*factorialArray(1+j))
        enddo  
      enddo
      
      HelmXS=HelmXS*1.0D+3 
   
    
    end subroutine
    subroutine Calculate_CVxs_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,CVXS,T,V,factorialArray)
     double precision Vref300(1),aij_matrix(6,3),fsn301(1),Tref300(1),thn301(1),CVXS,T,V,factorialArray(6)  

      integer i,j,lcount
      double precision V0,T0,m,n,fstr,theta,d_theta_dT,d2_theta_dT2
      double precision Contr(36)
      V0=Vref300(1)
      n=fsn301(1)
      T0= Tref300(1)
      m=thn301(1)
      
      
     

      ! Define the two adimentional functions for T et V
      fstr = 1.0D+0/n*((V0/V)**(n/3.0D+0)-1.0D+0)
      theta = ((T/T0)**m-1.0D+0)
      
      d_theta_dT=(T/T0)**m*m/T
      d2_theta_dT2=(T/T0)**m*m*(m-1)/T**2.0D+0
      
      CVXS=0.0D+0
     
    
      do i=0,5
        do j=0,2
          
          CVXS=CVXS+aij_matrix(i+1,j+1)*fstr**i*theta**j*j**2.0D+0*d_theta_dT**2.0D+0/(theta**2.0D+0*factorialArray(i+1)*factorialArray(j+1))+aij_matrix(i+1, j+1)*fstr**i*theta**j*j*d2_theta_dT2/(theta*factorialArray(i+1)*factorialArray(j+1))-aij_matrix(i+1, j+1)*fstr**i*theta**j*j*d_theta_dT**2.0D+0/(theta**2.0D+0*factorialArray(i+1)*factorialArray(j+1))
        enddo  
      enddo
      
      CVXS=-T*CVXS*1.0D+3 

    end subroutine
    subroutine Calculate_KTxs_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,KTXS,T,V,factorialArray)
     double precision Vref300(1),aij_matrix(6,3),fsn301(1),Tref300(1),thn301(1),KTXS,T,V,factorialArray(6)  

      integer i,j,lcount
      double precision V0,T0,m,n,fstr,theta,d_f_dV,d2_f_dV2
      double precision Contr(36)
      V0=Vref300(1)
      n=fsn301(1)
      T0= Tref300(1)
      m=thn301(1)
      
      
     

      ! Define the two adimentional functions for T et V
      fstr = 1.0D+0/n*((V0/V)**(n/3.0D+0)-1.0D+0)
      theta = ((T/T0)**m-1.0D+0)
      
      d_f_dV=-(1.0D+0/3.0D+0)*(V0/V)**((1.0D+0/3.0D+0)*n)/(V*1.0D-6)
      d2_f_dV2=(1.0D+0/9.0D+0)*(V0/V)**((1.0D+0/3.0D+0)*n)*(n+3.0D+0)/(V*1.0D-6)**2.0D+0
      
      KTXS=0.0D+0
     
    
      do i=0,5
        do j=0,2
          KTXS=KTXS+aij_matrix(i+1, j+1)*fstr**i*i**2.0D+0*d_f_dV**2.0D+0*theta**j/(fstr**2.0D+0*factorialArray(i+1)*factorialArray(j+1))+aij_matrix(i+1, j+1)*fstr**i*i*d2_f_dV2*theta**j/(fstr*factorialArray(i+1)*factorialArray(j+1))-aij_matrix(i+1, j+1)*fstr**i*i*d_f_dV**2.0D+0*theta**j/(fstr**2.0D+0*factorialArray(i+1)*factorialArray(j+1))
        enddo  
      enddo
      ! bulk modulus in GPa
      KTXS=(V*1.0D-6*KTXS*1.0D+3)*1.0D-9 

    end subroutine
     subroutine Calculate_alpha_KTxs_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,alpha_KTxs,T,V,factorialArray)
     double precision Vref300(1),aij_matrix(6,3),fsn301(1),Tref300(1),thn301(1),alpha_KTxs,T,V,factorialArray(6)  

      integer i,j,lcount
      double precision V0,T0,m,n,fstr,theta,d_f_dV,d_theta_dT
      double precision Contr(36)
      V0=Vref300(1)
      n=fsn301(1)
      T0= Tref300(1)
      m=thn301(1)
      
      
     

      ! Define the two adimentional functions for T et V
      fstr = 1.0D+0/n*((V0/V)**(n/3.0D+0)-1.0D+0)
      theta = ((T/T0)**m-1.0D+0)
      
      d_f_dV=-(1.0D+0/3.0D+0)*(V0/V)**((1.0D+0/3.0D+0)*n)/(V*1.0D-6)
      d_theta_dT=(T/T0)**m*m/T
      
      alpha_KTxs=0.0D+0
     
    
      do i=0,5
        do j=0,2
          alpha_KTxs=alpha_KTxs+i*j*aij_matrix(i+1,j+1)/factorialArray(i+1)/factorialArray(j+1)*fstr**(dble(i)-1.0D+0)*theta**(dble(j)-1.0D+0)
        enddo  
      enddo
   
      alpha_KTxs=-d_f_dV*d_theta_dT*alpha_KTxs*1.0D+3

    end subroutine
    
    
   subroutine Calculate_CVid(ntot,V,T,CVid,nspeci,atmass) 
   use Mod
   double precision ntot,V,T,CVid,atmass(3),q(3)
   integer nspeci(3)
     CVid=0.0D+0
     
     do i=1,3
       if (nspeci(i)>0.0D+0) then
         CVid=CVid+3.0D+0/2.0D+0*nspeci(i)      
       endif
     enddo
     
     CVid=kb_constant*N_Av*CVid
   
   end subroutine 
    
  subroutine Calculate_Selec(ntot,V,T,Selec,elbeto, elbetpow, elTeo, elTepow, elVo)
    double precision T_el,Zeta,ntot,V,T,Selec,elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1)
    
    Zeta = elbeto(1)*(V/elVo(1))**elbetpow(1)
    T_el= elTeo(1)*(V/elVo(1))**elTepow(1)
    
    Selec=Zeta*(T-T_el-T_el*dlog(T/T_el)) 
    
  end subroutine
  subroutine Calculate_CVelec(ntot,V,T,CVelec,elbeto, elbetpow, elTeo, elTepow, elVo)
    double precision T_el,Zeta,ntot,V,T,CVelec,elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1)
    
    Zeta = elbeto(1)*(V/elVo(1))**elbetpow(1)
    T_el= elTeo(1)*(V/elVo(1))**elTepow(1)
    
    CVelec=Zeta*(T-T_el) 
    
   end subroutine  
   subroutine Calculate_Pelec(ntot,V,T,Pelec,elbeto, elbetpow, elTeo, elTepow, elVo)
   double precision T_el,Zeta,ntot,V,T,Pelec,elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1),d_zeta_dV,d_Tel_dV
    d_zeta_dV= elbeto(1)*(V/elVo(1))**elbetpow(1)*elbetpow(1)/(V*1.0D-6)
    d_Tel_dV= elTeo(1)*(V/elVo(1))**elTepow(1)*elTepow(1)/(V*1.0D-6)
    Zeta = elbeto(1)*(V/elVo(1))**elbetpow(1)
    
    T_el= elTeo(1)*(V/elVo(1))**elTepow(1)
    
    Pelec=d_zeta_dV*(1.0D+0/2.0D+0*(T**2.0D+0-T_el**2.0D+0)-T*T_el*dlog(T/T_el))+Zeta*d_Tel_dV*((T-T_el)-T*dlog(T/T_el))
    Pelec=Pelec*1.0D-9
    end subroutine 
   
    subroutine Calculate_Felec(ntot,V,T,Felec,elbeto, elbetpow, elTeo, elTepow, elVo)  
     double precision T_el,Zeta,ntot,V,T,Felec,elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1)
     Zeta = elbeto(1)*(V/elVo(1))**elbetpow(1)
    
     T_el= elTeo(1)*(V/elVo(1))**elTepow(1)
    
     Felec=-Zeta*(0.5D+0*(T**2.0D+0-T_el**2.0D+0)-T*T_el*dlog(T/T_el))
    end subroutine    
   
   subroutine Calculate_K_T_elec(ntot,V,T,K_Telec,elbeto, elbetpow, elTeo, elTepow, elVo)   
   double precision T_el,Zeta,ntot,V,T,K_Telec,elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1),d2_zeta_dV2,d2_Tel_dV2
    
   Zeta = elbeto(1)*(V/elVo(1))**elbetpow(1) 
   T_el= elTeo(1)*(V/elVo(1))**elTepow(1)
   
   d_zeta_dV= elbeto(1)*(V/elVo(1))**elbetpow(1)*elbetpow(1)/(V*1.0D-6)
    d2_zeta_dV2= elbeto(1)*(V/elVo(1))**elbetpow(1)*elbetpow(1)**2/(V*1.0D-6)**2.0D+0-elbeto(1)*(V/elVo(1))**elbetpow(1)*elbetpow(1)/(V*1.0D-6)**2.0D+0
    
   d_Tel_dV= elTeo(1)*(V/elVo(1))**elTepow(1)*elTepow(1)/(V*1.0D-6)
   d2_Tel_dV2= elTeo(1)*(V/elVo(1))**elTepow(1)*elTepow(1)**2.0D+0/(V*1.0D-6)**2.0D+0-elTeo(1)*(V/elVo(1))**elTepow(1)*elTepow(1)/(V*1.0D-6)**2.0D+0
   
   K_Telec=(V*1.0D-6)*(-(d2_zeta_dV2)*((0.5D+0)*T**2.0D+0-(0.5D+0)*T_el**2.0D+0-T*T_el*dlog(T/T_el))-2.0D+0*(d_zeta_dV)*(-T_el*(d_Tel_dV)-T*(d_Tel_dV)*dlog(T/T_el)+T*(d_Tel_dV))-Zeta*(-(d_Tel_dV)**2.0D+0-T_el*(d2_Tel_dV2)-T*(d2_Tel_dV2)*dlog(T/T_el)+T*(d_Tel_dV)**2.0D+0/T_el+T*(d2_Tel_dV2)))
  
   K_Telec=K_Telec*1.0D-9 
   endsubroutine 
   subroutine Calculate_alpha_K_T_elec(ntot,V,T,alpha_K_Telec,elbeto, elbetpow, elTeo, elTepow, elVo)    
   double precision T_el,Zeta,ntot,V,T,alpha_K_Telec,elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1),d_zeta_dV,d_Tel_dV
     Zeta = elbeto(1)*(V/elVo(1))**elbetpow(1)
    
     T_el= elTeo(1)*(V/elVo(1))**elTepow(1)
     d_zeta_dV= elbeto(1)*(V/elVo(1))**elbetpow(1)*elbetpow(1)/(V*1.0D-6)
     d_Tel_dV= elTeo(1)*(V/elVo(1))**elTepow(1)*elTepow(1)/(V*1.0D-6)
     alpha_K_Telec=(d_zeta_dV)*(T-T_el*dlog(T/T_el)-T_el)-Zeta*d_Tel_dV*dlog(T/T_el)
     
     
   end subroutine   
    
   subroutine Calculate_Helmid(ntot,V,T,Helmid,nspeci,atmass) 
   use Mod
   double precision ntot,V,T,Helmid,atmass(3),q(3)
   integer nspeci(3)
     Helmid=0.0D+0
     
     do i=1,3
       if (nspeci(i)>0.0D+0) then
         q(i)=(atmass(i)/N_Av*1D-3*kb_constant *T/(2*Pi*h_bar**2.0D+0))**(3.0D+0/2.0D+0)
         Helmid=Helmid+nspeci(i)*log(V*1.0D-6*dexp(1.0D+0)*q(i)/(nspeci(i)*N_Av))
       endif
     enddo
     
     Helmid=-kb_constant*T*N_Av*Helmid
   
   end subroutine 
   
    subroutine Calculate_Pid(ntot,V,T,Pid)
    double precision ntot,V,T,Pid,Helmid
      Pid=ntot*8.31451*T/(V*1.D-3)*1.D-6
    
    end subroutine
    
    program Helmholtz_koker

    implicit none

    ! Variables
    character*200 FileName
    double precision aepfit300(1,36),Helm_E,PXS,ntot
    double precision T,V,Vref300(1),fsn301(1),Tref300(1),thn301(1),Pid,Vmin,Vmax,Pmin,Pmax,PTarget,Ptot,atmass(3),S_ideal
    integer nepfit300(1),i,j,nspeci(3)
    double precision aij_matrix(6,3),factorialArray(6),Helmid,SXS,KTXS,CVid,CVXS,alpha_KTXS,alphaXS
    double precision elbeto(1), elbetpow(1), elTeo(1), elTepow(1), elVo(1),Selec,CVelec,Pelec,Felec,K_Telec,alpha_K_Telec,alpha_elec,alpha_tot,gamma,KT_tot,CV_tot,CP_tot,Stot,Ptotal,KS_tot
    factorialArray=1.0D+0
    do i=1,5
      factorialArray(i+1)=factorialArray(i)*i
    enddo
    

   
   ! fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.j15lq'
  ! fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.siliq'
  !  fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.peliq'
  !  fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.j51lq'
  !  fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.j21lq'
  !  fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.j32lq'
  !  fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.j11lq'
 !  fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.j12lq'
    fileName = 'C:\srcfortran\Helmholtz_koker\Helmholtz_koker\helm_inp.j13lq'
     
    
    call ReadDeKokerFile (fileName,aepfit300,nepfit300,Vref300,fsn301,Tref300,thn301,ntot,nspeci,atmass,elbeto, elbetpow, elTeo, elTepow, elVo)
    call ConvertParameters (aij_matrix,aepfit300)
  
    T=3000.000001D+0
    V=Vref300(1)
 
    OPEN(UNIT=3, FILE='results.txt', STATUS='unknown')
   ! do i=-1,100
      !V=Vref300(1)*0.999999999D+0-i/100.0D+0*Vref300(1)*0.6D+0
      V=Vref300(1)*0.999999999D+0
      call  Calculate_HelmXS_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,Helm_E,T,V,factorialArray)
      call Calculate_Helmid(ntot,V,T,Helmid,nspeci,atmass)
      
      call Calculate_PXS_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,PXS,T,V,factorialArray)
      call Calculate_Pid(ntot,V,T,Pid)
    
      call Calculate_SXS_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,SXS,T,V,factorialArray)
      call Calculate_Sideal(ntot,V,T,S_ideal,nspeci,atmass) 
      
      
      call Calculate_CVxs_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,CVXS,T,V,factorialArray)
      call Calculate_CVid(ntot,V,T,CVid,nspeci,atmass)
      
      call Calculate_KTxs_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,KTXS,T,V,factorialArray)
      
      call Calculate_alpha_KTxs_Compact(Vref300,fsn301,Tref300,thn301,aij_matrix,alpha_KTXS,T,V,factorialArray)
      alphaXS=alpha_KTXS/(KTXS*1.0D+9)
      
      
      call Calculate_Selec(ntot,V,T,Selec,elbeto, elbetpow, elTeo, elTepow, elVo)
      call Calculate_CVelec(ntot,V,T,CVelec,elbeto, elbetpow, elTeo, elTepow, elVo)
      call Calculate_Pelec(ntot,V,T,Pelec,elbeto, elbetpow, elTeo, elTepow, elVo)
      call Calculate_Felec(ntot,V,T,Felec,elbeto, elbetpow, elTeo, elTepow, elVo)  
      call Calculate_K_T_elec(ntot,V,T,K_Telec,elbeto, elbetpow, elTeo, elTepow, elVo)   
      call Calculate_alpha_K_T_elec(ntot,V,T,alpha_K_Telec,elbeto, elbetpow, elTeo, elTepow, elVo)   
      alpha_elec=alpha_K_Telec/(K_Telec*1.0D+9)
      
     
      alpha_tot=(alpha_KTXS+alpha_K_Telec+1.0D+0/T*Pid*1.0D+9)/(KTXS+Pid+K_Telec)/1.0D+9
      
      KT_tot=KTXS+Pid+K_Telec
      CV_tot=CVXS+CVid+CVelec
      Stot=(SXS+S_ideal+Selec)
      Ptotal=PXS+Pid+Pelec
      
      gamma=alpha_tot*(KT_tot*1.0D+9)/CV_tot*V*1.0D-6
      CP_tot=(1+T*alpha_tot*gamma)*CV_tot
      KS_tot=(1+T*alpha_tot*gamma)*KT_tot
      
      write (*,*) 'Molar Volume:         ',V,' cm3/mol'
      write (*,*) 'Isotherm. Bulk modulus: ',(KT_tot),' GPa'
      write (*,*) 'Adiaba. Bulk modulus: ',(KS_tot),' GPa'
      
      write (*,*) 'alpha:                  ',(alpha_tot),' 1/K'
      write (*,*) 'Total entropy:          ',Stot,' J/K'
      write (*,*) 'CV:                     ',CV_tot/8.31451D+0/ntot,' Nkb'
      write (*,*) 'CP:                     ',CP_tot/8.31451D+0/ntot,' Nkb'
      write (*,*) 'gamma:                  ',gamma
      
      write (*,*) 'Total pressure:         ',Ptotal,' GPa'
      write (*,*) 'Total Helmholtz energy: ',(Helm_E+Helmid+Felec)*1.0D-3,' kJ'
    WRITE(3,*) V,PXS+Pid+Pelec
    CLOSE(UNIT=3)  
    end program Helmholtz_koker
