{**
@abstract(@html(
<pre><span style="font-weight: bold; color: rgb(0, 0, 0);">procedure</span><span
 style="color: rgb(0, 0, 0);"> add(</span><span
 style="font-weight: bold; color: rgb(0, 0, 0);">var</span><span
 style="color: rgb(0, 0, 0);"> r: mtx; a:mtx; b:mtx);</span></pre>
  Element / element matrix operation: r = a OPR b<br>
  "a" and "b" must either have the same dimensions or be
  a row or column vector of the same size as "a" (or "b") or a (1,1) matrix.
  In the latter cases the row and/or column is duplicated
  so that the resulting operands have the same sizes;
  The result "r" dimensions will be that of the largest argument "a" or "b".<br>
  <a href="ex/add_rab1.pas.html">Example 1</a><br>
  <a href="ex/add_rab2.pas.html">Example 2</a><br>
  <a href="ex/add_rab3.pas.html">Example 3</a><br>
  <a href="ex/softdim.html"><em>Soft dimensions</em> in arithmetic
          expressions</a><br>
))}
procedure add(var r: mtx; a:mtx; b:mtx);
begin
  if (a.col<b.col) or (a.lgn<b.lgn)
    then cpy(r,xpd(a,b))
    else cpy(r,a);
  opr(r,b,@opradd);
  wtrace(r,a,b,'add')
end;

{**
@abstract( @html(
 <pre><span style="font-weight: bold; color: rgb(0, 0, 0);">procedure</span><span
 style="color: rgb(0, 0, 0);"> add(</span><span
 style="font-weight: bold; color: rgb(0, 0, 0);">var</span><span
 style="color: rgb(0, 0, 0);"> r: mtx; a:mtx; x:</span><span
 style="color: rgb(128, 0, 0);">double</span><span
 style="color: rgb(0, 0, 0);">);</span></pre>
 <tt>r(i,j) = a(i,j) OPR x</tt><br>
 <a href="ex/add_rax.pas.html">Example</a><br>
 <a href="ex/softdim.html"><em>Soft dimensions</em> in arithmetic
          expressions</a><br>
))}
procedure add(var r: mtx; a:mtx; x:double);
begin
  mym(x11,x,1,1);
  cpy(r,a);
  opr(r,x11,@opradd);
  wtrace(r,a,x11,'add')
end;

{**
@abstract( @html(
 <pre><span style="font-weight: bold; color: rgb(0, 0, 0);">procedure</span><span
 style="color: rgb(0, 0, 0);"> add(</span><span
 style="font-weight: bold; color: rgb(0, 0, 0);">var</span><span
 style="color: rgb(0, 0, 0);"> r: mtx; x:</span><span
 style="color: rgb(128, 0, 0);">double</span><span
 style="color: rgb(0, 0, 0);">; a:mtx);</span></pre>
 <tt>r(i,j) = x OPR a(i,j)</tt><br>
 <a href="ex/add_rax.pas.html">Example</a><br>
 <a href="ex/softdim.html"><em>Soft dimensions</em> in arithmetic
          expressions</a><br>
))}
procedure add(var r: mtx; x:double; a:mtx);
begin
  mym(x11,x,1,1);
  cpy(r,xpd(x11,a));
  opr(r,a,@opradd);
  wtrace(r,x11,a,'add')
end;

{**
@abstract(@html(
<pre><span style="font-weight: bold; color: rgb(0, 0, 0);">procedure</span><span
 style="color: rgb(0, 0, 0);"> add(a, b:mtx);</span></pre>
<tt> a = a OPR b </tt><br>
<a href="ex/add_ab.pas.html">Example</a><br>
<a href="ex/softdim.html"><em>Soft dimensions</em> in arithmetic expressions</a>
))}
procedure add(a, b:mtx);
begin
  opr(a,b,@opradd);
  wtrace(a,b,'add')
end;

{**
@abstract(@html(
<pre><span style="font-weight: bold; color: rgb(0, 0, 0);">procedure</span><span
 style="color: rgb(0, 0, 0);"> add(a: mtx; x: </span><span
 style="color: rgb(128, 0, 0);">double</span><span
 style="color: rgb(0, 0, 0);">);</span></pre><tt>a = a OPR x</tt><br>
 <a href="ex/add_ax.pas.html">Example</a><br>
 <a href="ex/softdim.html"><em>Soft dimensions</em> in arithmetic
          expressions</a>))

}
procedure add(a: mtx; x: double);
begin
  mym(x11,x,1,1);
  opr(a,x11,@opradd);
  wtrace(a,'add')
end;

{**
@abstract(@html(
<pre><span style="font-weight: bold; color: rgb(0, 0, 0);">procedure</span><span
 style="color: rgb(0, 0, 0);"> add(</span><span
 style="font-weight: bold; color: rgb(0, 0, 0);">var</span><span
 style="color: rgb(0, 0, 0);"> x: </span><span
 style="color: rgb(128, 0, 0);">double</span><span
 style="color: rgb(0, 0, 0);">; a:mtx);</span></pre>

 <tt>x OPR= a(i,j)</tt> for all i,j<br>
 <a href="ex/add_ax.pas.html">Example</a><br>
 <a href="ex/softdim.html"><em>Soft dimensions</em> in arithmetic
          expressions</a>
))}
procedure add(var x: double; a:mtx);
begin
  mym(x11,x,1,1);
  opr(x11,a,@opradd);
  wtrace(x11,a,'add')
end;

{**
@abstract(@html(
<pre><span style="font-weight: bold; color: rgb(0, 0, 0);">procedure</span><span
 style="color: rgb(0, 0, 0);"> add(</span><span
 style="font-weight: bold; color: rgb(0, 0, 0);">var</span><span
 style="color: rgb(0, 0, 0);"> r: mtx; a:mtx; p:</span><span
 style="color: rgb(128, 0, 0);">boolean</span><span
 style="color: rgb(0, 0, 0);">);</span></pre>
Cumulative operator OPR by row or column depending on <tt>p</tt>.<br>
If p is true then the result r will have the size of a row of a else a column
of a. The value of each element of r is the accumulation by the operator OPR of
the element of the corresponding column ( row ) of a.<br>
<a href="ex/add_rap.pas.html">Example</a>
))}
procedure add(var r: mtx; a:mtx; p:boolean);
begin
  if p then
    dim(r,1,col(a),addnullelm)
  else
    dim(r,lgn(a),1,addnullelm);
  opr(r,a,@opradd);
  wtrace(r,a,'add')
end;
