{$H+}
{$C+}
program minmax;
// returns min max values of the first (and if exist) the second
// columns of a table (matrix) read from stdin
// cat OneCol.xy | minmax ---> xmin xmax
// cat TwoCol.xy | minmax ---> xmin xmax ymin ymax
uses mtx09;
const
  Infinity=1e300;
var
  d, r:mtx;
  x, y: double;
  xmin: double = Infinity;
  xmax: double = -Infinity;
  ymin: double = Infinity;
  ymax: double = -Infinity;
  i, m, n: longint;
begin
  mrd(d);
  // mwr(d);
  m := lgn(d);
  n := col(d);
  if n>1 then zer(r,1,4) else zer(r,1,2);
  for i := 1 to m do begin
    x := elm(d,i,1);
    if x>xmax then xmax:=x;
    if x<xmin then xmin:=x;
    if n>1 then begin
      y := elm(d,i,2);
      if y>ymax then ymax:=y;
      if y<ymin then ymin:=y
    end
  end;
  elm(r,1,1,xmin);
  elm(r,1,2,xmax);
  if n>1 then begin
    elm(r,1,3,ymin);
    elm(r,1,4,ymax);
  end;
  mwr(r)
end.
