{$H+}
{$C+}
program jogminmax;
// returns min max values of the first and the second
// columns of a table (matrix) read from stdin
// output jog statements defining Xmin Xmax Ymin Ymax
// suitable for the plot (small margins added) and
// graduation using an external command "/usr/local/jog07/src/grad"
uses mtx09;

const
  Infinity=1e300;

var
  d: mtx;
  x, y, dx, dy: double;
  xmin: double = Infinity;
  xmax: double = -Infinity;
  ymin: double = Infinity;
  ymax: double = -Infinity;
  i, m, n: longint;

// write bash assignment s=<valeur>
procedure writa(var f: text; x: double; s:string);
const
  r=4.99E-7;
  wd=0; // using tab as delimiter so fieldwidth 0 is ok
  sf=6; // was 5 check that it makes no problem
var
  y:double; p,pp,de,w,dc:longint;
  intg,n,ne:boolean;
begin
  if (abs(x)<=maxint) then intg:=abs(x-trunc(x))=0 else intg:=false;
  write(f,s+'=');
  if intg then write(f,trunc(x):wd) else begin
    n := x<0;
    if n then y:=-x else y:=x;
    p:=0;
    while (y>=10) do begin y:=y/10; p:=succ(p) end;
    while (y<1)   do begin y:=y*10; p:=pred(p) end;
    if (p=0) then write(f,x:wd:sf-1) else begin
      ne:=p<0;
      if ne then pp:=-p else pp:=p;
      de:=2;
      while (pp>9) do begin pp:=pp div 10; de:=succ(de) end;
      if ne then de:=succ(de);
      y:=y+double(r);
      w:=wd-de;
      if (p>-(sf-2)) and (p<sf) then begin
        dc:=pred(sf-p);
        if (dc<1) then dc:=1;
        write(f,x:wd:dc) // TODO check if sf=6 make sense ?
      end else
        if n then write(f,-y:w:pred(sf),'E',p:1)
             else write(f,y:w:pred(sf),'E',p:1)
    end
  end;
  writeln(f)
end;

begin
  mrd(d);
  m := lgn(d);
  n := col(d);
  for i := 1 to m do begin
    x := elm(d,i,1);
    if x>xmax then xmax:=x;
    if x<xmin then xmin:=x;
    if n>1 then begin
      y := elm(d,i,2);
      if y>ymax then ymax:=y;
      if y<ymin then ymin:=y
    end
  end;
  dx := (xmax-xmin)/25.0;
  writa(stdout,xmin-dx,'Xmin');
  writa(stdout,xmax+dx,'Xmax');
  if n>1 then begin
    dy := (ymax-ymin)/25.0;
    writa(stdout,ymin-dy,'Ymin');
    writa(stdout,ymax+dy,'Ymax');
  end;
  flush(stdout)
end.
