% $Id: gxy.i,v 1.1.1.1 2006-12-29 17:13:08 jroux Exp $
% $Date: 2006-12-29 17:13:08 $

%  ver. 1.7a  counttomark
%----------------------------------------------------------------------
%  s1:string s2:string  Concat -> s3:string
%----------------------------------------------------------------------
/Concat{
  /Var 5 dict def
  Var begin
  /s2 exch def
  /s1 exch def
  /n1 s1 length def
  /n2 s2 length def
  /s3 n1 n2 add string def
  s3 0  s1 putinterval
  s3 n1 s2 putinterval
  s3
  end
} def

%----------------------------------------------------------------------
%  x d Str -> s   % conversion single->string avec d decimales
%----------------------------------------------------------------------
/Str{
/StrVar 9 dict def
StrVar begin
  /d exch def
  d 0 lt {/d 0 def} if
  /dd d def
  /x exch def
  /negatif x 0 lt def
  /x x abs def
  {
    dd 0 lt {}{exit}ifelse
    /x x 10 div def
    /dd dd 1 add def
  } loop
  {
    dd 0 gt {}{exit}ifelse
    /x x 10 mul def
    /dd dd -1 add def
  } loop
  /ix x round cvi def
  /sx ix 20 string cvs def
  {sx length d le {}{exit}ifelse /sx (0) sx Concat def} loop
  /l sx length def
  /sd sx l d neg add d getinterval def
  d 0 gt {/sd (.) sd  Concat def} if
  /se sx 0 l d neg add getinterval def
  /sx se sd Concat def
  negatif {/sx (-) sx Concat def} if
  sx
% sx print (--------\n) print
end
} def

%------------------- Constantes ---------------------------------------
/Gx [] def /Gy [] def % pour dsactiver l'ancienne version
/XG1 1     def  % taille des petites graduations
/XG2 2     def  % taille des moyennes graduations
/XG3 3     def  % taille des grandes graduations
/Px -1.2   def  % dcalage en interligne des grad. X (Px<0 : dessous)
/Lx  true  def  % active les labels sur l'axe X
/AbsX false def % graduations en valeur absolue pour X: bidouille
                % pour spectres Raman de gauche->droite en ngatif !
/YG1 1     def  % taille des petites graduations
/YG2 2     def  % taille des moyennes graduations
/YG3 3     def  % taille des grandes graduations
/Py -0.2   def  % dcalage en interligne des grad. X (Py<0 : a gauche)
/Qy -0.3   def  % dcalage des labels Y en ITL (-0.3 pour centrer en gros
                % 0 pour aligner le bas sur le trait...
/Ly  true  def  % active les labels sur l'axe Y
%----------------------------------------------------------------------
%     x Scale -> e  y  avec x = e*y; e=10^n 1<=y<10
%----------------------------------------------------------------------
/Scale{
  /ScaleVar 4 dict def
ScaleVar begin
  /e 1     def
  /x exch  def
  /n  x 0 lt def
  /x x abs def
  {
    x 1 lt {}{exit} ifelse
    /x x 10 mul def
    /e e 10 div def
  } loop
  {
    x 10 gt {}{exit} ifelse
    /x x 10 div def
    /e e 10 mul def
  } loop
  n {e neg}{e} ifelse
  x
end
} def

%----------------------------------------------------------------------
%  Mini Maxi Largeur(mm) GrXY -> x0 dx1 dx2 dx3
%----------------------------------------------------------------------
/GrXY{
  /GrXYvar 14 dict def
  GrXYvar begin
    /Width exch def
    /Max exch def
    /Min exch def
    /dy Max Min neg add def
    /d1 dy Width div ITL mul 4 div def
    d1 Scale
    /y1 exch def
    /e1 exch def
    y1 1.1 lt {/id1 1 def}{
    y1 2.5 lt {/id1 2 def}{
    y1 7.0 lt {/id1 5 def}{
               /id1 10 def
    } ifelse
    } ifelse
    } ifelse
    /id2 id1 5 mul def
    Width 15 ITL mul lt {/id3 2 id2 mul def}{
      id1 5 lt {/id3 id2 5 mul def}{
              /id3 id2 4 mul def
    } ifelse
    } ifelse
    /n3 Min id3 div e1 div truncate def
    Min 0 lt {/n3 n3 -1 add def} if
    /y0 n3 id3 mul e1 mul def
    /d1 e1 id1 mul def
    /d2 e1 id2 mul def
    /d3 e1 id3 mul def
    y0 d1 d2 d3
  end
} def


%----------------------------------------------------------------------
%  Graduation et lgendes des Axes X, usage : X0 dx1 dx2 dx3 AxeX
%
%  X0 : dbut des labels (peut tre < Xmin)
%       espacements des...
%  dx1 :  petites graduations
%  dx2 :  grandes graduations
%  dx3 :  labels
%----------------------------------------------------------------------
/AxeX{
  /AxeXvar 12 dict def
  AxeXvar begin
    counttomark 0 eq { Xmin Xmax Lg GrXY} if
    InitClip
    Px 0 ge
      {/O2 {gt} def /O1 {ge} def}
      {/O2 {ge} def /O1 {gt} def}
    ifelse
    %------------------- Paramtres -----------------------------------
    /dx3 exch def
    /dx2 exch def
    /dx1 exch def
    /X0  exch def
    /Decim dx3 Scale pop log neg round cvi def
    %------------------- Petites graduations en bas -------------------
    /xx X0 def
    /yy Ymin def
    newpath
    xx yy Moveto
    {
       xx Xmax O1 {exit} if
       xx Xmin O2 {
         xx yy Moveto
         0  XG1 rlineto
         0  XG1 neg rmoveto
       } if
       /xx xx dx1 add def
    } loop
    stroke
    %------------------- Petites graduations en haut ------------------
    newpath
    /xx X0 def
    /yy Ymax def
    xx yy Moveto
    {
       xx Xmax O1 {exit} if
       xx Xmin O2 {
         xx yy Moveto
         0 XG1 neg rlineto
         0 XG1 rmoveto
       } if
       /xx xx dx1 add def
    } loop
    stroke
    %------------------- Grandes graduations en bas -------------------
    /xx X0 def
    /yy Ymin def
    newpath
    xx yy Moveto
    {
       xx Xmax O1 {exit} if
       xx Xmin O2 {
         xx yy Moveto
         0  XG2 rlineto
         0  XG2 neg rmoveto
       } if
       /xx xx dx2 add def
    } loop
    stroke
    %------------------- Grandes graduations en haut ------------------
    newpath
    /xx X0 def
    /yy Ymax def
    xx yy Moveto
    {
       xx Xmax O1 {exit} if
       xx Xmin O2 {
         xx yy Moveto
         0 XG2 neg rlineto
         0 XG2 rmoveto
       } if
       /xx xx dx2 add def
    } loop
    stroke
    %------------------- Lgendes de l'axe X --------------------------
    Lx {
      /yy Ymin def
      /xx X0 def
      {
        xx Xmax O1 {exit} if
        xx Xmin O2
        {
          newpath
          xx yy Moveto
          0 XG3 rlineto
          0 XG3 neg rmoveto stroke
          /lb xx AbsX {abs} if Decim Str def
          xx yy Moveto 0 ITL Px mul rmoveto lb TC
        }
        if
        /xx xx dx3 add def
      } loop
    } if
    Masquer
} def

%----------------------------------------------------------------------
%  Graduation et lgendes des Axes Y, usage : Y0 dy1 dy2 dy3 AxeY
%----------------------------------------------------------------------
/AxeY{
  /AxeYvar 12 dict def
  AxeYvar begin
    %------------------------------------------------------------------
    counttomark 0 eq {Ymin Ymax Lg GrXY} if
    InitClip
    Py 0 ge
      {/O2 {gt} def /O1 {ge} def}
      {/O2 {ge} def /O1 {gt} def}
    ifelse
    %------------------- Paramtres -----------------------------------
    /dy3 exch def
    /dy2 exch def
    /dy1 exch def
    /Y0 exch def
    /Decim dy3 Scale pop log neg round cvi def
    %------------------- Petites graduations  gauche------------------
    newpath
    /xx Xmin def
    /yy Y0   def
    {
       yy Ymax O1 {exit} if
       yy Ymin O2 {
         xx yy Moveto
         YG1 0 rlineto
         YG1 neg 0 rmoveto
       } if
       /yy yy dy1 add def
    } loop
    stroke
    %------------------- Petites graduations  droite -----------------
    newpath
    /xx Xmax def
    /yy Y0 def
    {
       yy Ymax O1 {exit} if
       yy Ymin O2 {
         xx yy Moveto
         YG1 neg 0 rlineto
         YG1 0 rmoveto
       } if
       /yy yy dy1 add def
    } loop
    stroke
    %------------------- Grandes graduations  gauche -----------------
    /xx Xmin def
    /yy Y0 def
    newpath
    {
       yy Ymax O1 {exit} if
       yy Ymin O2 {
         xx yy Moveto
         YG2 0  rlineto
         YG2 neg 0  rmoveto
       } if
       /yy yy dy2 add def
    } loop
    stroke
    %------------------- Grandes graduations  droite -----------------
    /xx Xmax def
    /yy Y0 def
    newpath
    {
       yy Ymax O1 {exit} if
       yy Ymin O2 {
         xx yy Moveto
         YG2 neg 0  rlineto
         YG2 0  rmoveto
       } if
       /yy yy dy2 add def
    } loop
    stroke
    %------------------- Lgendes de l'axe Y --------------------------
    Ly {
      /xx Xmin def
      /yy Y0 def
      {
        yy Ymax O1 {exit} if
        yy Ymin O2 {
          newpath
          xx yy Moveto
          YG3 0 neg rlineto
          YG3 0 rmoveto stroke
          /lb yy Decim Str def
          xx yy Moveto
          Py  ITL mul
          Qy  ITL mul
            rmoveto
          lb Py 0 gt {TG}{TD} ifelse
        } if
        /yy yy dy3 add def
      } loop
    } if
    %------------------------------------------------------------------
    Masquer
  end
} def
%----------------------------------------------------------------------

