%
% $Id: courbe.i,v 1.1.1.1 2006/12/29 17:13:08 jroux Exp $
% $Date: 2006/12/29 17:13:08 $
%
%=======================================================================
%
% Variables globales
%
/Detail  false def % voir les points de conduite pour Patate
/Remplis false def % avec remplissage
/Raideur 0.3 def   % du trac  ] 0 1 [

%=======================================================================
% UTILITAIRES DE TRANSFORMATION DES ARGUMENTS pour
% se comporter comme les autres instructions de trac
%
% x0 dx [y0..yn] dxy2xy -> [x0 y0 x1 y1... xn yn]
%
/dxy2xy {
 /dxy2xyVar 8 dict def
  dxy2xyVar begin
    /y exch def  %  y[0..n]
    /dx exch def
    /x0 exch def
    /xy y length 2 mul array def
    /n  y length -1 add def
    /x x0 def
    0 1 n {
      /i exch def
      /j i 2 mul def
      xy j x put
      xy j 1 add y i get put
      /x i 1 add dx mul x0 add def
    } for
    xy
  end
} def
%--------------------------------------------
%  [x1..xn][y1..yn] -> [x1 y1...xn yn]
%--------------------------------------------
/xy2xy {
/xy2xyVar 7 dict def
xy2xyVar begin
  /y exch def
  /x exch def
  /l x length def
  /v l 2 mul array def
  0 1 l -1 add {
    /i exch def
    /j i 2 mul def
    /k j 1 add def
    v j x i get put
    v k y i get put
  } for
  v
end
} def

%------------------------------------------------------
% Trace en mode sujet d'un lment de courbe de Bsier
% de point courant -> d avec points de conduite b et c
%            bx by cx cy dx dy Crb
% (avec transformation conforme XY2xy si elle existe)
% newpath  T transform XY2xy moveto puis plus. appels
%  crb finis par (fill) stroke
%------------------------------------------------------
/crb {
/crbVar 6 dict def
crbVar begin
  /dy exch def
  /dx exch def
  /cy exch def
  /cx exch def
  /by exch def
  /bx exch def
  bx by T transform XY2xy
  cx cy T transform XY2xy
  dx dy T transform XY2xy curveto
end
} def

%--------------------------------------------------
% Trace en mode sujet d'une courbe ouverte
% [x y...] Courbe
% [x...] [y...] Courbe
% x dx [y...] Courbe
%--------------------------------------------------
/Courbe {
/CourbeVar 20 dict def
CourbeVar begin
  counttomark 2 eq { xy2xy } if
  counttomark 3 eq { dxy2xy } if
  /a Raideur def
  /v exch def
  /l v length def
  /n l 2 idiv -2 add def
  /g l array def
  g 0 0 put
  g 1 0 put
  /d l array def
  d l -1 add 0 put
  d l -2 add 0 put
  1 1 n {
    /i exch def
    /ix i 2 mul def
    /iy ix 1 add def
    /dxg   v ix get   v ix -2 add get   neg add def
    /dxd   v ix 2 add get   v ix get neg add def
    /dyg v iy get v iy -2 add get neg add def
    /dyd v iy 2 add get v iy get neg add def
    g ix
        v ix get a dxg dxd add mul neg add
      put
    g iy
        v iy get a dyg dyd add mul neg add
      put
    d ix
        v ix get a dxg dxd add mul add
      put
    d iy
        v iy get a dyg dyd add mul add
      put
  } for
  g ix 2 add d ix get put
  g iy 2 add d iy get put
  d 0 g 2 get put
  d 1 g 3 get put
  newpath
  v 0 get v 1 get T transform XY2xy moveto
  0 1 n {
    /i exch def
    /j i 1 add def
    /ix i 2 mul def
    /iy ix 1 add def
    /jx j 2 mul def
    /jy jx 1 add def
    d ix get d iy get
    g jx get g jy get
    v jx get v jy get
    crb
  } for
  stroke
end
} def

%--------------------------------------------------
% Trace en mode sujet d'une courbe ferme
% [x y...] Patate
% [x...] [y...] Patate
% x dx [y...] Patate
%--------------------------------------------------
/Patate {
/PatateVar 15 dict def
PatateVar begin
  counttomark 2 eq { xy2xy } if
  counttomark 3 eq { dxy2xy } if
  /a Raideur def
  /v exch def
  /l v length def
  /g l array def
  /d l array def
  /n l 2 div def
  1 1 n { /i exch def
    /jx 2 i 1 sub mul def
    /jy jx 1 add def
    /sjx jx 2 add def sjx l ge {/sjx sjx l sub def} if
    /sjy sjx 1 add def
    /pjx jx 2 sub def pjx 0 lt {/pjx pjx l add def} if
    /pjy pjx 1 add def
    /dx a v sjx get v pjx get sub mul def
    /dy a v sjy get v pjy get sub mul def
    g jx v jx get dx sub put
    g jy v jy get dy sub put
    d jx v jx get dx add put
    d jy v jy get dy add put
  } for
  newpath
  v 0 get v 1 get T transform XY2xy moveto
  1 1 n {/i exch def
    /jx 2 i 1 sub mul def
    /jy jx 1 add def
    /sjx jx 2 add def sjx l ge {/sjx sjx l sub def} if
    /sjy sjx 1 add def
    d jx get d jy get
    g sjx get g sjy get
    v sjx get v sjy get
    crb
  } for
  Remplis {fill} if
  stroke
  Detail
  {
    v Rond
    1 1 n { /i exch def
      /jx 2 i 1 sub mul def
      /jy jx 1 add def
      [g jx get g jy get d jx get d jy get] Ligne
    } for
  } if
  end
} def

