#! /bin/bash

CMD="../smo"

# test of background substraction on a small
# part of a powder diffractogram
# peaks located in the following zones (to skip)
x="
23.90 24.72
27.5  28.5
30    33
42    43.5
"

# NOTE below, double quotes around $x are required
# to keep together the numbers within a single string.
# bkg filtering is ok with -f2 ( i.e. double the e.s.e )
$CMD -x "$x" -f2 -b < tst.dat > tst1.xy
gx tst.dat tst1.xy &

# NOTE option -b and -d are exclusive because the substraction
# can only take place between compatible vectors !
# this is to test option -d <start> <step> to resample data on a regular grid
# start=11 steps=0.02
$CMD -x "$x" -f2 -d "11 0.02" < tst.dat > tst2.xy
$CMD         -f1 -d "11 0.02" < tst.dat > tst3.xy
# A tiny pascal code can be used to perform the bkg substraction
fpc adhoc
./adhoc > tst4.xy
# background removed and rebin on a regular grid
# as may be needed to compare diffractograms from different
# wavelength...
gx tst.dat tst4.xy &

# tst2.xy and tst3.xy are compatible same first col.
# the substraction can be done a small ad hoc code
