''#10+
'     *************************************************************'#10+
'     * smo   --- oct 2010  ---                                   *'#10+
'     * Non parametric fit and differentiation  using gcv splines *'#10+
'     *         and background smoothing / substraction           *'#10+
'     * cf. gcv (http://netlib.org/gcv) credit in source gcvspl.f *'#10+
'     * uses matrix library mtx09.pas   ---  roux@ipgp.jussieu.fr *'#10+
'     *************************************************************'#10+
''#10+
'**** INTENDED USAGE ****'#10+
''#10+
'  ** The first example is the recommanded sensible usage:'#10+
'  ** 3 columns data file x(i) y(i) ese(i). x strictly monotonous,'#10+
'  ** y are the noisy observations of a smooth function, and ese the'#10+
'  ** estimated standard errors:'#10+
''#10+
'        smo  < my.dat > my.out'#10+
''#10+
'  ** my.out, 5 cols: x(i) smoothed_y(i) dy/dx d2y/dx2  0'#10+
'  ** spline coefficient table in ancillary output file smo.xy (cf. -s).'#10+
'  ** Next ex. interpolated values on an evenly spaced x(j) array,'#10+
'  ** 1000 segments (1001 values):'#10+
''#10+
'        smo -n 1000 < my.dat > my.out'#10+
''#10+
'  ** exclude a subrange of the data to interpolate the background'#10+
'  ** below peak(s); see also -x (excluded regions) and -f to'#10+
'  ** increase smoothing (multiply ese by the factor, default is 1.0)'#10+
'  ** which may typically be needed in this case.'#10+
'  ** -b option to calculate the observation minus interp. background'#10+
'  ** in 5th column of output file:'#10+
''#10+
'        smo -f 2.0 <my.xy >bkg.xy -x "7100 7150" -b'#10+
''#10+
'  ** interpolation on a regular grid (-d option) from 0 to 300K by 10K'#10+
'  ** and special listed values (-l option):'#10+
''#10+
'     smo -i Cp.dat -d "0 10 300" -l "273.15 298.15" -o Cp.xy'#10+
''#10+
'  ** full gcv, unknown ese, my.dat 2 columns xi yi:'#10+
''#10+
'        smo < my.dat > my.out'#10+
''#10+
'  ** 2 columns data file, same known ese for all observations,'#10+
'  ** given by -f option (NOTE the change in semantic with 3 cols data):'#10+
''#10+
'        smo -f 0.1 < my.dat > my.out'#10+
''#10+
'**** MAIN OPTIONS ******************************************************'#10+
''#10+
'   -i   input file  ( default: stdin; redirection with < is ok )'#10+
'        either 2 or (recommanded) 3 columns data. Each line is an'#10+
'        observation; 1st column independant variable, 2d: observation'#10+
'        and the optional third column the estimated standard error (ese)'#10+
'        of the observation.'#10+
''#10+
'        Variant: with the mtx name to search in the data file'#10+
'        separator "," or space " "  -i fnam,mnam  or -i "fnam  mnam"'#10+
''#10+
'   -o   output file ( default: stdout redirection with > is ok )'#10+
'        each line is: col 1: independant variable,'#10+
'        col 2: the smoothed and or inperpolated value of the dependant'#10+
'        variable, next columns first and second derivative, 5th either'#10+
'        null or background substracted observation where background is'#10+
'        smoothed in the non excluded regions ( cf. -x and -b options ).'#10+
''#10+
'   -f   filter parameter: if 2 columns data file then -f is = ese;'#10+
'        with 3 columns data file 3d col is ese and -f a multiplier'#10+
'        to increase/decrease all e.s.e. i.e. more/less smoothing.'#10+
''#10+
'        NOTE: -f <= 0 : NO smoothing but a simple cubic spline'#10+
'        interpolation between nodes ( same as netlib''s fmm spline.f ).'#10+
'        The same is achieved with special options -m 1 -v 0 which calls'#10+
'        gcvspl with mode=1 and valr=0 (cf. fortran source comments).'#10+
''#10+
'   -n   0   : smoothing on original x grid ( default )'#10+
'        n>0 : use n segments (n+1) interpolation points'#10+
'        see also option -d'#10+
''#10+
'   -d   "first,step" interpolate on a regularly spaced grid starting at first'#10+
'        within the original bounds of the data. first incremented by step'#10+
'        until greater than first data point. The number of step is such that'#10+
'        last data - step <  last interpolation point < last data'#10+
''#10+
'   -l   list of interp. absc. " 100 150 200 250 273.15 298.15"'#10+
'        WARNING they should belong to the experimental  data range.'#10+
''#10+
'   -r   region of interest e.g. the XANES part of an XAS spectrum...'#10+
'        treatment restricted to this region e.g. -r 7000,7300'#10+
''#10+
'   -x   matrix of x excluded brackets (smooth a background skiping peak'#10+
'        area in whatever spectroscopy ) e.g. -x "7100 7200; 8550 8600"'#10+
'        Note: spaces or "," as element delimiter and ";" as line delimiter,'#10+
'        a 2,2 matrix in the example.'#10+
''#10+
'   -b   kludge for background substraction using option -x to exclude'#10+
'        the peaks area; e.g raman, powder diffraction,...'#10+
'        WARNING: obviously (sic) exclusive with -d -l and -n options !'#10+
''#10+
'   -s   spline coeff. output file name; default name: "smo.xy"'#10+
'        5 columns: xi ai bi ci di, i=1..nb of spline nodes.'#10+
'        This file can be used for special evaluations such as'#10+
'        Intg(Cp/T.dT)/t1:t2 using analytical formula with the spline'#10+
'        coefficients. This file is written with either the default name'#10+
'        or the user supplied name in this option, in all cases.'#10+
''#10+
'**** OTHER OPTIONS *****************************************************'#10+
'*******************   see fortran gcvspl.f for usage of mode and val'#10+
''#10+
'   -m   mode of gcvspl_ fortran code def. 3 ( ese are known )'#10+
'        if 2 col. data (no ese)  -f will set ese or mode 2 use full gcv'#10+
''#10+
'   -v   val arg. of gcvspl_() fortran / should make sense with mode'#10+
''#10+
'*** HINTS **************************************************************'#10+
''#10+
'   -m 1 and -v O for interpolation without smoothing ( or -f 0 )'#10+
'   -m 2 to force full gcv on 3 col. data files.'#10+
'   -m 3 and -v ese^2 if uniform ese and only 2 col. of data (or -f ese)'#10+
''#10+
'****  limitations: use 3d degree splines only whereas gcvspl.f allows'#10+
'****  other degrees.'#10+
''#10+
'******************'#10+
'IMPORTANT WARNING:'#10+
'******************'#10+
''#10+
'free pascal compiler uses (unfortunately) shortstrings for the'#10+
'command line arguments. Therefore the max length for options arguments'#10+
'such as required by -r and -x must be shorter than 255 characters. If'#10+
'longer they are silently truncated. THIS IS BAD but that''s the way it is'#10+
'currently.'#10+
''#10+
'author: roux@ipgp.jussieu.fr'#10+
''#10;
