#! /bin/bash

TBL="result.txt"
Xmin="0"
Xmax="20"
Ymin="0"
Ymax="0.16"

# see equ. in text and NOTE Y scale * 100
a1="0.007609"
a2="0"

echo "
[ $Xmin $Xmax $Ymin $Ymax ] Axe2
[(5)(10)(15)(20)] GradX
[(0)(0.05)(0.1)(0.15)] GradY
( R_W_/_S ) GradX
( W / \(100-W\),  W: wt% water ) GradY
gsave
6 Size
0.7 setgray
[
"

#-----------------------------------------------------------------------
awk -v a1="$a1" -v a2="$a2" -v x0="$Xmin" -v x1="$Xmax"  '
BEGIN {
  dx = (x1-x0)/50
  for (x=x0;x<=x1;x+=dx) {
    y = x*(a1+x*a2)
    printf("%g\t%g\n",x,y)
  }
} '
#-----------------------------------------------------------------------

echo "
] Lines
grestore
gsave
%Clip

NoLines
2 Color Filled Circles
[
0 0
$(awk '$6=="hs" {printf("%s %g\n",$4,$3/(100-$3))}' $TBL)
] Plot

6 Color Filled Circles
[
0 0
$(awk '$6=="ms" {printf("%s %g\n",$4,$3/(100-$3))}' $TBL)
] Plot

10 Color Filled Circles
[
0 0
$(awk '$6=="ls" {printf("%s %g\n",$4,$3/(100-$3))}' $TBL)
] Plot

Black
180 400
(  2 Color Filled Circles)(hs) Label
(  6 Color Filled Circles)(ms) Label
( 10 Color Filled Circles)(ls) Label

grestore
"
